IF EXISTS (SELECT 1 FROM sysobjects WHERE id = object_id(N'UFD_RC_CLI_ALTERACAO') AND xtype IN (N'FN', N'IF', N'TF'))
    DROP FUNCTION UFD_RC_CLI_ALTERACAO
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 240216
'Job.................:  
'Nome................: [UFD_RC_CLI_ALTERACAO]
'Objetivo............: Essa UFD tem o propsito de retornar os dados do usurio do sistema que criou/alterou os dados de um cliente da farmcia.
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 16/02/2024
'Criado por..........: Eduardo Nunes De Souza Seixas
'Alterado por........: 
'Versionado por......: Marcos Barros
'=======================================================================================
 select * from UFD_RC_CLI_ALTERACAO (1,24544)
*/


CREATE FUNCTION UFD_RC_CLI_ALTERACAO (@CD_EMP INT, @CD_CLI INT)
RETURNS @RS_RETURN TABLE(
						 CD_EMP INT, 
						 CD_CLI INT, 
					     CD_USU_CAD INT,
						 DT_CAD DATE,  
						 NM_FUN_CAD VARCHAR(200),                          
						 CD_USU_ALT INT,    
                         DT_ALT DATE,
						 NM_FUN_ALT VARCHAR(200),
						 DS_CARGO VARCHAR(200)
                         )
AS
begin
INSERT INTO @RS_RETURN
SELECT 
	RC_CLI.CD_EMP,
	CD_CLI,	
	CASE
		WHEN (RC_CLI.DT_ULT_ALT IS NOT NULL AND (RC_CLI.CD_USU_ALT <> 0 OR RC_CLI.CD_USU_ALT IS NOT NULL))
			THEN 0
			ELSE RC_CLI.CD_USU
       END CD_USU_CAD,
	RC_CLI.DT_CAD,	
	CASE
		WHEN (RC_CLI.DT_ULT_ALT IS NOT NULL AND (RC_CLI.CD_USU_ALT <> 0 OR RC_CLI.CD_USU_ALT IS NOT NULL))
			THEN ''
			ELSE FP_FUNC.NM_FUN
    END NM_FUN_CAD,
	CD_USU_ALT,     
    RC_CLI.DT_ULT_ALT,
   CASE
		WHEN (RC_CLI.DT_ULT_ALT IS NOT NULL AND (RC_CLI.CD_USU_ALT <> 0 OR RC_CLI.CD_USU_ALT IS NOT NULL))
			THEN FP_FUNC.NM_FUN
			ELSE ''
    END NM_FUN_ALT,
	FP_CARGO.DS_CARGO
FROM RC_CLI 
	LEFT JOIN GLB_USU ON RC_CLI.CD_USU = GLB_USU.CD_USU	
	LEFT JOIN FP_FUNC ON GLB_USU.CD_USU = FP_FUNC.CD_FUNC_USU
		AND GLB_USU.CD_USU = FP_FUNC.CD_FUN		
	LEFT  JOIN FP_CARGO ON	FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
WHERE 
  RC_CLI.CD_EMP = @CD_EMP
  AND RC_CLI.CD_CLI = @CD_CLI
RETURN 
END